/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public final class ProjectGroup {
    @NotNull
    private String myName = "";
    private String myProjectPaths = "";
    private boolean myExpanded = false;
    private boolean myTutorials = false;

    public ProjectGroup(@NotNull String name) {
        this.myName = name;
    }

    public ProjectGroup() {
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public String getProjectPaths() {
        return this.myProjectPaths;
    }

    public void setProjectPaths(String projectPaths) {
        this.myProjectPaths = projectPaths;
    }

    public void addProject(@SystemIndependent String path2) {
        ArrayList<String> projects = new ArrayList<String>(StringUtil.split((String)this.myProjectPaths, (String)File.pathSeparator));
        projects.add(FileUtilRt.toSystemIndependentName((String)path2));
        this.save(projects);
    }

    public boolean markProjectFirst(@SystemIndependent String path2) {
        if (!this.myProjectPaths.contains(path2)) {
            return false;
        }
        List existing = StringUtil.split((String)this.myProjectPaths, (String)File.pathSeparator);
        int index = existing.indexOf(path2);
        if (index <= 0) {
            return false;
        }
        ArrayList<String> projects = new ArrayList<String>(existing.size());
        projects.add(path2);
        projects.addAll(existing.subList(0, index));
        projects.addAll(existing.subList(index + 1, existing.size()));
        this.save(projects);
        return true;
    }

    private void save(@NotNull List<String> projects) {
        this.myProjectPaths = String.join((CharSequence)File.pathSeparator, projects);
    }

    @NotNull
    public List<String> getProjects() {
        return new ArrayList<String>(new HashSet(StringUtil.split((String)this.myProjectPaths, (String)File.pathSeparator)));
    }

    public boolean removeProject(@SystemIndependent String path2) {
        List projects = StringUtil.split((String)this.myProjectPaths, (String)File.pathSeparator);
        if (!projects.remove(path2)) {
            return false;
        }
        this.save(projects);
        return true;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isTutorials() {
        return this.myTutorials;
    }

    public void setTutorials(boolean tutorials) {
        this.myTutorials = tutorials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroup group = (ProjectGroup)o;
        return this.myName.equals(group.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

