/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CliResult {
    public static final CliResult OK = new CliResult(0, null);
    public final int exitCode;
    @Nullable
    public final String message;

    public CliResult(int exitCode, @Nullable String message) {
        this.exitCode = exitCode;
        this.message = message;
    }

    @NotNull
    public static Future<CliResult> error(int exitCode, @Nullable String message) {
        return CompletableFuture.completedFuture(new CliResult(exitCode, message));
    }

    @NotNull
    public static CliResult unmap(@NotNull Future<CliResult> future, int errorCode) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new CliResult(errorCode, e.getMessage());
        }
    }
}

