/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.fileSet;

import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedScopeDescriptor
implements FileSetDescriptor {
    public static final String NAMED_SCOPE_TYPE = "namedScope";
    private final String myScopeName;
    @Nullable
    private PackageSet myFileSet;

    public NamedScopeDescriptor(@NotNull NamedScope scope) {
        this.myScopeName = scope.getName();
        this.myFileSet = scope.getValue();
    }

    public NamedScopeDescriptor(@NotNull String scopeName) {
        this.myScopeName = scopeName;
    }

    @Override
    public void setPattern(@Nullable String pattern) {
        try {
            this.myFileSet = pattern != null ? PackageSetFactory.getInstance().compile(pattern) : null;
        }
        catch (ParsingException e) {
            this.myFileSet = null;
        }
    }

    @Override
    public boolean matches(@NotNull PsiFile psiFile) {
        PackageSet fileSet;
        Pair<NamedScopesHolder, NamedScope> resolved = this.resolveScope(psiFile.getProject());
        if (resolved == null) {
            resolved = this.resolveScope(ProjectManager.getInstance().getDefaultProject());
        }
        if (resolved != null && (fileSet = ((NamedScope)resolved.second).getValue()) != null) {
            return fileSet.contains(psiFile, (NamedScopesHolder)resolved.first);
        }
        if (this.myFileSet != null) {
            DependencyValidationManager holder = DependencyValidationManager.getInstance(psiFile.getProject());
            return this.myFileSet.contains(psiFile, holder);
        }
        return false;
    }

    private Pair<NamedScopesHolder, NamedScope> resolveScope(@NotNull Project project) {
        NamedScopesHolder holder = DependencyValidationManager.getInstance(project);
        NamedScope scope = holder.getScope(this.myScopeName);
        if (scope == null) {
            holder = NamedScopeManager.getInstance(project);
            scope = holder.getScope(this.myScopeName);
        }
        return scope != null ? Pair.create((Object)holder, (Object)scope) : null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myScopeName;
    }

    @Override
    @NotNull
    public String getType() {
        return NAMED_SCOPE_TYPE;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.myFileSet != null ? this.myFileSet.getText() : null;
    }

    @Nullable
    public PackageSet getFileSet() {
        return this.myFileSet;
    }

    public String toString() {
        return "scope: " + this.myScopeName;
    }
}

