/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FacetDependentToolWindow
extends ToolWindowEP {
    public static final ExtensionPointName<FacetDependentToolWindow> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.facet.toolWindow");
    @RequiredElement
    @Attribute(value="facetIdList")
    public String facetIdList;

    @NotNull
    public String[] getFacetIds() {
        return this.facetIdList.split(",");
    }

    @NotNull
    public List<FacetType<?, ?>> getFacetTypes() {
        String @NotNull [] facetIds = this.getFacetIds();
        if (facetIds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(facetIds.length);
        FacetTypeRegistry facetTypeRegistry = FacetTypeRegistry.getInstance();
        for (String facetId : facetIds) {
            FacetType o = facetTypeRegistry.findFacetType(facetId);
            if (o == null) continue;
            result.add(o);
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }
}

