/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    private static final Logger LOG = Logger.getInstance(SettingsConnectionService.class);
    protected static final String SERVICE_URL_ATTR_NAME = "url";
    private Map<String, String> myAttributesMap;
    @Nullable
    private final String mySettingsUrl;
    @Nullable
    private final String myDefaultServiceUrl;

    protected String @NotNull [] getAttributeNames() {
        return new String[]{SERVICE_URL_ATTR_NAME};
    }

    protected SettingsConnectionService(@Nullable String settingsUrl, @Nullable String defaultServiceUrl) {
        this.mySettingsUrl = settingsUrl;
        this.myDefaultServiceUrl = defaultServiceUrl;
    }

    @Nullable
    public String getDefaultServiceUrl() {
        return this.myDefaultServiceUrl;
    }

    @Nullable
    private Map<String, String> readSettings(String ... attributes) {
        if (this.mySettingsUrl == null) {
            return Collections.emptyMap();
        }
        return HttpRequests.request(this.mySettingsUrl).productNameAsUserAgent().connect(request -> {
            LinkedHashMap<String, String> settings = new LinkedHashMap<String, String>();
            try {
                Element root = JDOMUtil.load((Reader)request.getReader());
                for (String s : attributes) {
                    String attributeValue = root.getAttributeValue(s);
                    if (!StringUtil.isNotEmpty((String)attributeValue)) continue;
                    settings.put(s, attributeValue);
                }
            }
            catch (JDOMException e) {
                LOG.info((Throwable)e);
            }
            return settings;
        }, Collections.emptyMap(), LOG);
    }

    @Nullable
    public String getServiceUrl() {
        String serviceUrl = this.getSettingValue(SERVICE_URL_ATTR_NAME);
        return serviceUrl == null ? this.getDefaultServiceUrl() : serviceUrl;
    }

    @Nullable
    protected String getSettingValue(@NotNull String attributeValue) {
        if (this.myAttributesMap == null || this.myAttributesMap.isEmpty()) {
            this.myAttributesMap = this.readSettings(this.getAttributeNames());
        }
        return this.myAttributesMap != null ? this.myAttributesMap.get(attributeValue) : null;
    }
}

