/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseViewAction
extends DumbAwareAction {
    @Override
    public final void update(@NotNull AnActionEvent e) {
        ViewContext context = this.getViewFacade(e);
        Content[] content = this.getContent(e);
        if (context != null && content != null) {
            if (this.containsInvalidContent(content)) {
                e.getPresentation().setEnabled(false);
            } else {
                this.update(e, context, content);
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    private boolean containsInvalidContent(Content[] content) {
        for (Content each : content) {
            if (each.isValid()) continue;
            return true;
        }
        return false;
    }

    protected void update(AnActionEvent e, ViewContext context, Content[] content) {
    }

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        this.actionPerformed(e, this.getViewFacade(e), this.getContent(e));
    }

    protected abstract void actionPerformed(AnActionEvent var1, ViewContext var2, Content[] var3);

    @Nullable
    private ViewContext getViewFacade(AnActionEvent e) {
        return e.getData(ViewContext.CONTEXT_KEY);
    }

    private Content @Nullable [] getContent(AnActionEvent e) {
        return e.getData(ViewContext.CONTENT_KEY);
    }

    @Nullable
    protected static Tab getTabFor(ViewContext context, Content[] content) {
        Grid grid = context.findGridFor(content[0]);
        return context.getTabFor(grid);
    }

    protected final void setEnabled(AnActionEvent e, boolean enabled) {
        e.getPresentation().setVisible(enabled);
    }
}

