/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class NestedGroupFragment<S extends FragmentedSettings>
extends SettingsEditorFragment<S, JComponent> {
    private final NotNullLazyValue<List<SettingsEditorFragment<S, ?>>> myChildren = NotNullLazyValue.createValue(() -> {
        List<SettingsEditorFragment<S, ?>> children = this.createChildren();
        for (SettingsEditorFragment<S, ?> child : children) {
            Disposer.register((Disposable)this, child);
            child.addSettingsEditorListener(editor -> {
                if (child.isSelected()) {
                    this.setSelected(true);
                }
                this.updateVisibility();
                this.fireEditorStateChanged();
            });
        }
        return children;
    });
    private JComponent myGroupComponent;

    protected NestedGroupFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Sentence) String group, Predicate<S> initialSelection) {
        super(id, name, group, null, null, null, initialSelection);
    }

    @Override
    public final List<SettingsEditorFragment<S, ?>> getChildren() {
        return (List)this.myChildren.getValue();
    }

    @Override
    public String getChildrenGroupName() {
        return this.getName();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateVisibility();
    }

    @Override
    public boolean isInitiallyVisible(S s) {
        return super.isInitiallyVisible(s) || ContainerUtil.exists(this.getChildren(), fragment -> fragment.isInitiallyVisible(s));
    }

    private void updateVisibility() {
        this.myGroupComponent.setVisible(this.isSelected());
    }

    @Override
    protected void resetEditorFrom(@NotNull S s) {
        for (SettingsEditorFragment<S, ?> child : this.getChildren()) {
            child.resetEditorFrom(s);
        }
        this.updateVisibility();
    }

    @Override
    protected void applyEditorTo(@NotNull S s) throws ConfigurationException {
        for (SettingsEditorFragment<S, ?> child : this.getChildren()) {
            child.applyEditorTo(s);
        }
    }

    protected abstract List<SettingsEditorFragment<S, ?>> createChildren();

    @Override
    @NotNull
    protected JComponent createEditor() {
        this.myGroupComponent = new FragmentedSettingsBuilder(this.getChildren(), this).createCompoundEditor();
        if (this.myComponent == null) {
            this.myComponent = this.myGroupComponent;
        }
        this.updateVisibility();
        return this.myGroupComponent;
    }
}

