/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FragmentedSettingsEditor<Settings extends FragmentedSettings>
extends CompositeSettingsEditor<Settings> {
    private final NotNullLazyValue<Collection<SettingsEditorFragment<Settings, ?>>> myFragments = NotNullLazyValue.createValue(() -> this.createFragments());

    protected abstract Collection<SettingsEditorFragment<Settings, ?>> createFragments();

    protected final Collection<SettingsEditorFragment<Settings, ?>> getFragments() {
        return (Collection)this.myFragments.getValue();
    }

    private Stream<SettingsEditorFragment<Settings, ?>> getAllFragments() {
        return this.getFragments().stream().flatMap(fragment -> Stream.concat(fragment.getChildren().stream(), Stream.of(fragment)));
    }

    @Override
    public void resetEditorFrom(@NotNull Settings settings) {
        super.resetEditorFrom(settings);
        @Nullable Set<String> visibleFragments = settings.getSelectedOptions();
        for (SettingsEditorFragment fragment : this.getAllFragments().collect(Collectors.toList())) {
            fragment.setSelected(visibleFragments.isEmpty() ? fragment.isInitiallyVisible(settings) : visibleFragments.contains(fragment.getId()));
        }
    }

    @Override
    public void applyEditorTo(@NotNull Settings settings) throws ConfigurationException {
        super.applyEditorTo(settings);
        settings.setSelectedOptions(this.getAllFragments().filter(fragment -> fragment.isSelected()).map(fragment -> fragment.getId()).collect(Collectors.toSet()));
    }

    @Override
    public CompositeSettingsBuilder<Settings> getBuilder() {
        return new FragmentedSettingsBuilder<Settings>(this.getFragments(), null);
    }
}

