/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentHintManager {
    private final List<SettingsEditorFragment<?, ?>> myFragments = new ArrayList();
    @NotNull
    private final Consumer<? super String> myHintConsumer;
    private final String myDefaultHint;

    public FragmentHintManager(@NotNull Consumer<? super String> hintConsumer, @Nullable String defaultHint) {
        this.myHintConsumer = hintConsumer;
        this.myDefaultHint = defaultHint;
        hintConsumer.consume((Object)defaultHint);
    }

    public void registerFragments(Collection<? extends SettingsEditorFragment<?, ?>> fragments) {
        fragments.forEach(fragment -> this.registerFragment((SettingsEditorFragment<?, ?>)fragment));
    }

    public void registerFragment(final SettingsEditorFragment<?, ?> fragment) {
        this.myFragments.add(fragment);
        Object component = fragment.component();
        if (component instanceof RawCommandLineEditor) {
            component = ((RawCommandLineEditor)component).getEditorField();
        }
        ((Component)component).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FragmentHintManager.this.showHint(fragment);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FragmentHintManager.this.showHint(null);
            }
        });
        ((Component)component).addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FragmentHintManager.this.showHint(fragment);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FragmentHintManager.this.showHint(null);
            }
        });
    }

    private void showHint(@Nullable SettingsEditorFragment<?, ?> fragment) {
        String hint = this.myDefaultHint;
        if (fragment != null) {
            hint = fragment.getHint();
        } else {
            SettingsEditorFragment focused = (SettingsEditorFragment)ContainerUtil.find(this.myFragments, f -> ((Component)f.component()).hasFocus());
            if (focused != null) {
                hint = focused.getHint();
            }
        }
        this.myHintConsumer.consume((Object)(hint == null ? this.myDefaultHint : hint));
    }
}

