/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class CompositeTargetValue<S, T>
implements TargetValue<T> {
    @NotNull
    private final Collection<TargetValue<S>> myValues;
    @NotNull
    private final Function<? super Collection<S>, ? extends T> myMapper;

    CompositeTargetValue(@NotNull Collection<TargetValue<S>> values, @NotNull Function<? super Collection<S>, ? extends T> mapper) {
        this.myValues = values;
        this.myMapper = mapper;
    }

    @Override
    public Promise<T> getLocalValue() {
        return Promises.collectResults((Collection)ContainerUtil.map(this.myValues, TargetValue::getLocalValue)).then(this.myMapper);
    }

    @Override
    public Promise<T> getTargetValue() {
        return Promises.collectResults((Collection)ContainerUtil.map(this.myValues, TargetValue::getTargetValue)).then(this.myMapper);
    }
}

