/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTargetEnvironmentRequest
implements TargetEnvironmentRequest {
    private static int nextSyntheticId = 0;
    private TargetEnvironmentRequest.Volume myDefaultVolume;
    private final Map<String, LocalDownloadVolume> myDownloadRoots = new LinkedHashMap();
    private final Map<String, LocalUploadVolume> myUploadRoots = new LinkedHashMap();
    @NotNull
    private GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return TargetPlatform.CURRENT;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createUploadRoot(null, true);
        }
        return this.myDefaultVolume;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.Volume createUploadRoot(@Nullable String remoteRootPath, boolean temporary) {
        String id = LocalTargetEnvironmentRequest.nextSyntheticId();
        if (remoteRootPath == null) {
            remoteRootPath = id;
        }
        return this.myUploadRoots.computeIfAbsent(remoteRootPath, path2 -> new LocalUploadVolume(this, id));
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.DownloadableVolume createDownloadRoot(@Nullable String remoteRootPath) {
        String id = LocalTargetEnvironmentRequest.nextSyntheticId();
        if (remoteRootPath == null) {
            remoteRootPath = "";
        }
        return this.myDownloadRoots.computeIfAbsent(remoteRootPath, path2 -> new LocalDownloadVolume(this, id, (String)path2));
    }

    @Override
    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        return TargetValue.fixed(targetPort);
    }

    @Override
    @NotNull
    public TargetValue<HostPort> bindLocalPort(int localPort) {
        return TargetValue.fixed(new HostPort("localhost", localPort));
    }

    @NotNull
    GeneralCommandLine.ParentEnvironmentType getParentEnvironmentType() {
        return this.myParentEnvironmentType;
    }

    private static String nextSyntheticId() {
        return LocalTargetEnvironmentRequest.class.getSimpleName() + ":volume:" + nextSyntheticId++;
    }

    public void setParentEnvironmentType(@NotNull GeneralCommandLine.ParentEnvironmentType parentEnvironmentType) {
        this.myParentEnvironmentType = parentEnvironmentType;
    }

    private static class LocalDownloadVolume
    extends LocalUploadVolume
    implements TargetEnvironmentRequest.DownloadableVolume {
        private final String myRootPath;

        LocalDownloadVolume(@NotNull LocalTargetEnvironmentRequest request, @NotNull String volumeId, @NotNull String rootPath) {
            super(request, volumeId);
            this.myRootPath = rootPath;
        }

        @Override
        @NotNull
        public String getRemoteRoot() {
            return this.myRootPath;
        }

        @Override
        @NotNull
        public TargetValue<String> createDownload(@NotNull String rootRelativePath) {
            String fullPath = LocalDownloadVolume.concatPaths(this.myRootPath, rootRelativePath);
            return TargetValue.fixed(fullPath);
        }

        @NotNull
        private static String concatPaths(@NotNull String parent, @NotNull String child) {
            return StringUtil.isEmptyOrSpaces((String)parent) ? child : parent + Platform.current().fileSeparator + child;
        }
    }

    private static class LocalUploadVolume
    implements TargetEnvironmentRequest.Volume {
        private final LocalTargetEnvironmentRequest myRequest;
        private final String myVolumeId;

        LocalUploadVolume(@NotNull LocalTargetEnvironmentRequest request, @NotNull String volumeId) {
            this.myRequest = request;
            this.myVolumeId = volumeId;
        }

        @Override
        @NotNull
        public String getVolumeId() {
            return this.myVolumeId;
        }

        @Override
        @NotNull
        public Platform getPlatform() {
            return this.myRequest.getTargetPlatform().getPlatform();
        }

        @Override
        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            return TargetValue.fixed(localPath);
        }
    }
}

