/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class LocalTargetEnvironment
extends TargetEnvironment {
    public LocalTargetEnvironment(@NotNull TargetEnvironmentRequest request) {
        super(request);
    }

    @Override
    @NotNull
    public TargetPlatform getRemotePlatform() {
        return TargetPlatform.CURRENT;
    }

    @Override
    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        return this.createGeneralCommandLine(commandLine).createProcess();
    }

    @NotNull
    public GeneralCommandLine createGeneralCommandLine(@NotNull TargetedCommandLine commandLine) throws CantRunException {
        try {
            String inputFilePath;
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
            if (this.getRequest() instanceof LocalTargetEnvironmentRequest) {
                generalCommandLine.withParentEnvironmentType(((LocalTargetEnvironmentRequest)this.getRequest()).getParentEnvironmentType());
            }
            if ((inputFilePath = commandLine.getInputFilePath()) != null) {
                generalCommandLine.withInput(new File(inputFilePath));
            }
            generalCommandLine.withCharset(commandLine.getCharset());
            String workingDirectory = commandLine.getWorkingDirectory();
            if (workingDirectory != null) {
                generalCommandLine.withWorkDirectory(workingDirectory);
            }
            generalCommandLine.withEnvironment(commandLine.getEnvironmentVariables());
            return generalCommandLine;
        }
        catch (ExecutionException e) {
            throw new CantRunException(e.getMessage(), e);
        }
    }

    @Override
    public void shutdown() {
    }
}

