/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryOSProcessHandler
extends OSProcessHandler {
    private final BufferExposingByteArrayOutputStream myOutput = new BufferExposingByteArrayOutputStream();

    public BinaryOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
    }

    public BinaryOSProcessHandler(@NotNull Process process, @NotNull String commandLine, @Nullable Charset charset) {
        super(process, commandLine, charset);
    }

    public byte @NotNull [] getOutput() {
        return this.myOutput.toByteArray();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        return new SimpleBinaryReader(this.myProcess.getInputStream(), this.readerOptions().policy());
    }

    private class SimpleBinaryReader
    extends BinaryOutputReader {
        private SimpleBinaryReader(InputStream stream, BaseDataReader.SleepingPolicy policy) {
            super(stream, policy);
            this.start("output stream of " + BinaryOSProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(byte @NotNull [] data, int size) {
            BinaryOSProcessHandler.this.myOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return BinaryOSProcessHandler.this.executeTask(runnable);
        }
    }
}

