/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.UIBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultRunExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = "Run";

    @Override
    @NotNull
    public String getStartActionText() {
        return ExecutionBundle.message("default.runner.start.action.text", new Object[0]);
    }

    @Override
    @NotNull
    public String getToolWindowId() {
        return EXECUTOR_ID;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    @Override
    public Icon getDisabledIcon() {
        return IconLoader.getDisabledIcon((Icon)this.getIcon());
    }

    @Override
    public String getDescription() {
        return ExecutionBundle.message("standard.runner.description", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName() {
        return UIBundle.message("tool.window.name.run", new Object[0]);
    }

    @Override
    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @Override
    public String getContextActionId() {
        return "RunClass";
    }

    @Override
    public String getHelpId() {
        return "ideaInterface.run";
    }

    public static Executor getRunExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }
}

