/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.UIBundle;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultDebugExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = "Debug";
    private final String myStartActionText = XDebuggerBundle.message("debugger.runner.start.action.text", new Object[0]);
    private final String myDescription = XDebuggerBundle.message("string.debugger.runner.description", new Object[0]);

    @Override
    @NotNull
    public String getToolWindowId() {
        return EXECUTOR_ID;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowDebugger;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return AllIcons.Actions.StartDebugger;
    }

    @Override
    public Icon getDisabledIcon() {
        return IconLoader.getDisabledIcon((Icon)this.getIcon());
    }

    @Override
    @NotNull
    public String getActionName() {
        return UIBundle.message("tool.window.name.debug", new Object[0]);
    }

    @Override
    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @Override
    public String getContextActionId() {
        return "DebugClass";
    }

    @Override
    @NotNull
    public String getStartActionText() {
        return this.myStartActionText;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public String getHelpId() {
        return "debugging.DebugWindow";
    }

    public static Executor getDebugExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }
}

