/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface RunDashboardManager {
    public static final Topic<RunDashboardListener> DASHBOARD_TOPIC = Topic.create((String)"run dashboard", RunDashboardListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static RunDashboardManager getInstance(@NotNull Project project) {
        return (RunDashboardManager)project.getService(RunDashboardManager.class);
    }

    public ContentManager getDashboardContentManager();

    @NotNull
    public String getToolWindowId();

    @NotNull
    public Icon getToolWindowIcon();

    public void updateDashboard(boolean var1);

    public List<RunDashboardService> getRunConfigurations();

    public boolean isShowInDashboard(@NotNull RunConfiguration var1);

    @NotNull
    public Set<String> getTypes();

    public void setTypes(Set<String> var1);

    @NotNull
    public Predicate<Content> getReuseCondition();

    public static interface RunDashboardService {
        @NotNull
        public RunnerAndConfigurationSettings getSettings();

        @Nullable
        public RunContentDescriptor getDescriptor();

        @Nullable
        public Content getContent();
    }
}

