/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import com.pty4j.PtyProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance(PtyCommandLine.class);
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    private static final String UNIX_PTY_INIT = "unix.pty.init";
    private static final String UNIX_PTY_COLUMNS = "unix.pty.cols";
    private static final String UNIX_PTY_ROWS = "unix.pty.rows";
    private static final String WIN_PTY_COLUMNS = "win.pty.cols";
    private static final String WIN_PTY_ROWS = "win.pty.rows";
    public static final int MAX_COLUMNS = 2500;
    private boolean myUseCygwinLaunch;
    private boolean myConsoleMode = true;
    private int myInitialColumns = -1;
    private int myInitialRows = -1;
    private boolean myWindowsAnsiColorEnabled;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    public PtyCommandLine() {
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
    }

    @Deprecated
    public void setUseCygwinLaunch(boolean useCygwinLaunch) {
        this.withUseCygwinLaunch(useCygwinLaunch);
    }

    @Deprecated
    public void setConsoleMode(boolean consoleMode) {
        this.withConsoleMode(consoleMode);
    }

    @Deprecated
    public void setInitialColumns(int initialColumns) {
        this.withInitialColumns(initialColumns);
    }

    @Deprecated
    public void setInitialRows(int initialRows) {
        this.withInitialRows(initialRows);
    }

    public PtyCommandLine withUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myUseCygwinLaunch = useCygwinLaunch;
        return this;
    }

    public PtyCommandLine withConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
        return this;
    }

    public boolean isConsoleMode() {
        return this.myConsoleMode;
    }

    public PtyCommandLine withInitialColumns(int initialColumns) {
        this.myInitialColumns = initialColumns;
        return this;
    }

    public PtyCommandLine withInitialRows(int initialRows) {
        this.myInitialRows = initialRows;
        return this;
    }

    public PtyCommandLine(@NotNull List<String> command) {
        super(command);
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
    }

    public PtyCommandLine(@NotNull GeneralCommandLine original) {
        super(original);
        boolean bl = this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        if (original instanceof PtyCommandLine) {
            this.myUseCygwinLaunch = ((PtyCommandLine)original).myUseCygwinLaunch;
            this.myConsoleMode = ((PtyCommandLine)original).myConsoleMode;
            this.myInitialColumns = ((PtyCommandLine)original).myInitialColumns;
            this.myInitialRows = ((PtyCommandLine)original).myInitialRows;
        }
    }

    @NotNull
    PtyCommandLine withWindowsAnsiColorDisabled() {
        this.myWindowsAnsiColorEnabled = false;
        return this;
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (this.getInputFile() == null) {
            try {
                return this.startProcessWithPty(commands);
            }
            catch (Throwable t) {
                String message = "Couldn't run process with PTY";
                if (LOG.isDebugEnabled()) {
                    String logFileContent = PtyCommandLine.loadLogFile();
                    if (logFileContent != null) {
                        LOG.debug(message, new Object[]{t, logFileContent});
                    } else {
                        LOG.warn(message, t);
                    }
                }
                LOG.warn(message, t);
            }
        }
        return super.startProcess(commands);
    }

    @Nullable
    private static String loadLogFile() {
        File logFile;
        Application app = ApplicationManager.getApplication();
        File file = logFile = app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
        if (logFile != null && logFile.exists()) {
            try {
                return FileUtil.loadFile((File)logFile);
            }
            catch (Exception e) {
                return "Unable to retrieve pty log: " + e.getMessage();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands) throws IOException {
        Process process;
        ArrayList backup = new ArrayList();
        try {
            if (SystemInfo.isUnix && (this.myInitialColumns > 0 || this.myInitialRows > 0)) {
                PtyCommandLine.setSystemProperty(UNIX_PTY_INIT, Boolean.toString(true), backup);
                if (this.myInitialColumns > 0) {
                    PtyCommandLine.setSystemProperty(UNIX_PTY_COLUMNS, Integer.toString(this.myInitialColumns), backup);
                }
                if (this.myInitialRows > 0) {
                    PtyCommandLine.setSystemProperty(UNIX_PTY_ROWS, Integer.toString(this.myInitialRows), backup);
                }
            } else if (SystemInfo.isWindows) {
                if (this.myInitialColumns > 0) {
                    PtyCommandLine.setSystemProperty(WIN_PTY_COLUMNS, Integer.toString(this.myInitialColumns), backup);
                }
                if (this.myInitialRows > 0) {
                    PtyCommandLine.setSystemProperty(WIN_PTY_ROWS, Integer.toString(this.myInitialRows), backup);
                }
            }
            process = this.doStartProcessWithPty(commands);
        }
        catch (Throwable throwable) {
            for (Pair pair : backup) {
                PtyCommandLine.setSystemProperty((String)pair.first, (String)pair.second, null);
            }
            throw throwable;
        }
        for (Pair pair : backup) {
            PtyCommandLine.setSystemProperty((String)pair.first, (String)pair.second, null);
        }
        return process;
    }

    private static void setSystemProperty(@NotNull String propertyName, @Nullable String newPropertyValue, @Nullable List<? super Pair<String, String>> backup) {
        if (backup != null) {
            String oldValue = System.getProperty(propertyName);
            backup.add((Pair<String, String>)Pair.create((Object)propertyName, (Object)oldValue));
        }
        if (newPropertyValue != null) {
            System.setProperty(propertyName, newPropertyValue);
        } else {
            System.clearProperty(propertyName);
        }
    }

    @NotNull
    private Process doStartProcessWithPty(@NotNull List<String> commands) throws IOException {
        HashMap env = new HashMap();
        this.setupEnvironment(env);
        String[] command = ArrayUtilRt.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        boolean cygwin = this.myUseCygwinLaunch && SystemInfo.isWindows;
        Application app = ApplicationManager.getApplication();
        PtyProcessBuilder builder = new PtyProcessBuilder(command).setEnvironment(env).setDirectory(directory).setConsole(this.myConsoleMode).setCygwin(cygwin).setLogFile(app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null).setRedirectErrorStream(this.isRedirectErrorStream()).setWindowsAnsiColorEnabled(this.myWindowsAnsiColorEnabled);
        return builder.start();
    }
}

