/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EncodingEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EncodingEnvironmentUtil.class);
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String LANG = "LANG";

    @Deprecated
    public static void setLocaleEnvironmentIfMac(@NotNull GeneralCommandLine commandLine) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), commandLine.getCharset());
        }
    }

    @Deprecated
    public static void setLocaleEnvironmentIfMac(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, charset);
        }
    }

    private static void setLocaleEnvironment(@NotNull Map<String, String> env, @NotNull Charset charset) {
        env.put(LC_CTYPE, EncodingEnvironmentUtil.formatLocaleValue(charset));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fixed mac locale: " + charset.name());
        }
    }

    @NotNull
    private static String formatLocaleValue(@NotNull Charset charset) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        return (language.isEmpty() || country.isEmpty() ? "en_US" : language + "_" + country) + "." + charset.name();
    }

    private static boolean isLocaleDefined(@NotNull GeneralCommandLine commandLine) {
        return EncodingEnvironmentUtil.isLocaleDefined(commandLine.getEnvironment()) || EncodingEnvironmentUtil.isLocaleDefined(commandLine.getParentEnvironment());
    }

    private static boolean isLocaleDefined(@NotNull Map<String, String> env) {
        return !env.isEmpty() && (env.containsKey(LC_CTYPE) || env.containsKey(LC_ALL) || env.containsKey(LANG));
    }
}

