/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.hosting;

import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RepositoryListLoader {
    public boolean isEnabled();

    default public boolean enable(@Nullable Component parentComponent) {
        return this.enable();
    }

    @Deprecated
    default public boolean enable() {
        return false;
    }

    @NotNull
    default public List<String> getAvailableRepositories(@NotNull ProgressIndicator progressIndicator) throws RepositoryListLoadingException {
        return Collections.emptyList();
    }

    @NotNull
    default public Result getAvailableRepositoriesFromMultipleSources(@NotNull ProgressIndicator progressIndicator) {
        try {
            return new Result(this.getAvailableRepositories(progressIndicator), Collections.emptyList());
        }
        catch (RepositoryListLoadingException e) {
            return new Result(Collections.emptyList(), Collections.singletonList(e));
        }
    }

    public static class Result {
        @NotNull
        private final List<String> myUrls;
        @NotNull
        private final List<RepositoryListLoadingException> myErrors;

        public Result(@NotNull List<String> urls, @NotNull List<RepositoryListLoadingException> errors) {
            this.myUrls = urls;
            this.myErrors = errors;
        }

        @NotNull
        public List<String> getUrls() {
            return this.myUrls;
        }

        @NotNull
        public List<RepositoryListLoadingException> getErrors() {
            return this.myErrors;
        }
    }
}

