/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffRequest
extends ContentDiffRequest {
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<String> myContentTitles;

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent content1, @NotNull DiffContent content2, @Nullable String title1, @Nullable String title2) {
        this(title, Arrays.asList(content1, content2), Arrays.asList(title1, title2));
    }

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull DiffContent content3, @Nullable String title1, @Nullable String title2, @Nullable String title3) {
        this(title, Arrays.asList(content1, content2, content3), Arrays.asList(title1, title2, title3));
    }

    public SimpleDiffRequest(@Nullable String title, @NotNull List<DiffContent> contents, @NotNull List<String> titles) {
        assert (contents.size() == titles.size());
        this.myTitle = title;
        this.myContents = contents;
        this.myContentTitles = titles;
    }

    @Override
    @NotNull
    public List<DiffContent> getContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public List<String> getContentTitles() {
        return this.myContentTitles;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        for (DiffContent content : this.myContents) {
            content.onAssigned(isAssigned);
        }
    }
}

