/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeCallback {
    private static final Logger LOG = Logger.getInstance(MergeCallback.class);
    private static final Key<MergeCallback> KEY = Key.create((String)"com.intellij.diff.merge.MergeCallback");
    private static final MergeCallback EMPTY = new MergeCallback();

    public void applyResult(@NotNull MergeResult result) {
    }

    public boolean checkIsValid() {
        return true;
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
    }

    @NotNull
    public static <T extends MergeRequest> T register(@NotNull T request, @Nullable MergeCallback callback) {
        LOG.assertTrue(((MergeRequest)request).getUserData(KEY) == null);
        if (callback != null) {
            ((MergeRequest)request).putUserData(KEY, (MergeCallback)callback);
        }
        return (T)request;
    }

    @NotNull
    public static <T extends MergeRequest> T register(@NotNull T request, final @Nullable Consumer<? super MergeResult> callback) {
        return MergeCallback.register(request, new MergeCallback(){

            @Override
            public void applyResult(@NotNull MergeResult result) {
                if (callback != null) {
                    callback.consume((Object)result);
                }
            }
        });
    }

    @NotNull
    public static MergeCallback getCallback(@NotNull MergeRequest request) {
        MergeCallback callback = request.getUserData(KEY);
        return callback != null ? callback : EMPTY;
    }

    public static void retarget(@NotNull MergeRequest original, @NotNull MergeRequest target) {
        original.resultRetargeted();
        MergeCallback callback = original.getUserData(KEY);
        original.putUserData(KEY, null);
        target.putUserData(KEY, callback);
    }

    public static interface Listener
    extends EventListener {
        default public void fireConflictInvalid() {
        }
    }
}

