/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class ImplementationConflictException
extends RuntimeException {
    @NotNull
    private final Collection<Class<?>> myConflictingClasses;

    public ImplementationConflictException(String message, Throwable cause, Object ... implementationObjects) {
        super(message, cause);
        ArrayList classes = new ArrayList(implementationObjects.length);
        for (Object object : implementationObjects) {
            classes.add(object.getClass());
        }
        this.myConflictingClasses = Collections.unmodifiableList(classes);
    }

    @NotNull
    public Collection<Class<?>> getConflictingClasses() {
        return this.myConflictingClasses;
    }
}

