/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentSerializationUtil {
    @NotNull
    public static <S> Class<S> getStateClass(@NotNull Class<? extends PersistentStateComponent> aClass) {
        TypeVariable variable = PersistentStateComponent.class.getTypeParameters()[0];
        Type type = ReflectionUtil.resolveVariableInHierarchy(variable, aClass);
        assert (type != null) : aClass;
        Class result = ReflectionUtil.getRawType((Type)type);
        if (result == Object.class) {
            return aClass;
        }
        return result;
    }

    public static <S> void loadComponentState(@NotNull PersistentStateComponent<S> configuration, @Nullable Element element) {
        if (element != null) {
            Class<S> stateClass = ComponentSerializationUtil.getStateClass(configuration.getClass());
            Element state = stateClass.equals(Element.class) ? element : XmlSerializer.deserialize((Element)element, stateClass);
            configuration.loadState(state);
        }
    }
}

