/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lang;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RefManagerExtension<T> {
    @NotNull
    public Key<T> getID();

    @NotNull
    default public Collection<Language> getLanguages() {
        return Collections.singleton(this.getLanguage());
    }

    @Deprecated
    @NotNull
    public Language getLanguage();

    public void iterate(@NotNull RefVisitor var1);

    public void cleanup();

    public void removeReference(@NotNull RefElement var1);

    @Nullable
    public RefElement createRefElement(@NotNull PsiElement var1);

    @Nullable
    default public PsiNamedElement getElementContainer(@NotNull PsiElement psiElement) {
        return null;
    }

    @Nullable
    public RefEntity getReference(String var1, String var2);

    @Nullable
    public String getType(@NotNull RefEntity var1);

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity var1);

    public void visitElement(@NotNull PsiElement var1);

    @Nullable
    public String getGroupName(@NotNull RefEntity var1);

    public boolean belongsToScope(@NotNull PsiElement var1);

    public void export(@NotNull RefEntity var1, @NotNull Element var2);

    public void onEntityInitialized(@NotNull RefElement var1, @NotNull PsiElement var2);

    default public boolean shouldProcessExternalFile(@NotNull PsiFile file) {
        return false;
    }

    @NotNull
    default public Stream<? extends PsiElement> extractExternalFileImplicitReferences(@NotNull PsiFile psiFile) {
        return Stream.empty();
    }

    default public void markExternalReferencesProcessed(@NotNull RefElement file) {
    }
}

