/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtilRt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionElementsMerger {
    public static final ExtensionPointName<InspectionElementsMerger> EP_NAME = ExtensionPointName.create((String)"com.intellij.inspectionElementsMerger");
    private static Map<String, InspectionElementsMerger> ourMergers;
    private static final ConcurrentMap<String, InspectionElementsMerger> ourAdditionalMergers;

    private static synchronized void resetMergers() {
        ourMergers = null;
    }

    @Nullable
    public static InspectionElementsMerger getMerger(@NotNull String shortName) {
        InspectionElementsMerger additionalMerger = (InspectionElementsMerger)ourAdditionalMergers.get(shortName);
        return additionalMerger == null ? InspectionElementsMerger.getMergers().get(shortName) : additionalMerger;
    }

    private static synchronized Map<String, InspectionElementsMerger> getMergers() {
        if (ourMergers == null) {
            HashMap<String, InspectionElementsMerger> mergers = new HashMap<String, InspectionElementsMerger>();
            for (InspectionElementsMerger merger : EP_NAME.getExtensionList()) {
                mergers.put(merger.getMergedToolName(), merger);
            }
            ourMergers = mergers;
            return ourMergers;
        }
        return ourMergers;
    }

    static void addMerger(@NotNull String shortName, @NotNull InspectionElementsMerger merger) {
        ourAdditionalMergers.put(shortName, merger);
    }

    @Contract(pure=true)
    @NotNull
    public abstract String getMergedToolName();

    @Contract(pure=true)
    public abstract String @NotNull [] getSourceToolNames();

    @Contract(pure=true)
    public String @NotNull [] getSuppressIds() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static String getMergedToolName(@NotNull String id) {
        for (InspectionElementsMerger merger : EP_NAME.getExtensionList()) {
            for (String sourceToolName : merger.getSourceToolNames()) {
                if (!id.equals(sourceToolName)) continue;
                return merger.getMergedToolName();
            }
            for (String suppressId : merger.getSuppressIds()) {
                if (!id.equals(suppressId)) continue;
                return merger.getMergedToolName();
            }
        }
        return null;
    }

    static {
        ourAdditionalMergers = new ConcurrentHashMap<String, InspectionElementsMerger>();
        EP_NAME.addChangeListener(InspectionElementsMerger::resetMergers, null);
    }
}

