/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface RefactoringQuickFix
extends LocalQuickFix {
    @Override
    default public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public RefactoringActionHandler getHandler();

    @NotNull
    default public RefactoringActionHandler getHandler(DataContext context) {
        return this.getHandler();
    }

    default public PsiElement getElementToRefactor(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof PsiNamedElement ? parent : element;
    }

    default public void doFix(@NotNull PsiElement element) {
        PsiElement elementToRefactor = this.getElementToRefactor(element);
        if (elementToRefactor == null) {
            return;
        }
        Consumer consumer = dataContext -> {
            dataContext = this.enhanceDataContext((DataContext)dataContext);
            RefactoringActionHandler handler = this.getHandler((DataContext)dataContext);
            handler.invoke(element.getProject(), new PsiElement[]{elementToRefactor}, (DataContext)dataContext);
        };
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(consumer);
    }

    @Override
    default public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.doFix(descriptor.getPsiElement());
    }

    @NotNull
    default public DataContext enhanceDataContext(@NonNls DataContext context) {
        return context;
    }
}

