/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixOnPsiElementAsIntentionAdapter
implements IntentionAction {
    @NotNull
    private final LocalQuickFixOnPsiElement myFix;

    public LocalQuickFixOnPsiElementAsIntentionAdapter(@NotNull LocalQuickFixOnPsiElement fix2) {
        this.myFix = fix2;
    }

    @Override
    @NotNull
    public String getText() {
        return this.myFix.getName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.myFix.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myFix.isAvailable();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myFix.applyFix();
    }

    @Override
    public boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myFix.getElementToMakeWritable(currentFile);
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        LocalQuickFixOnPsiElement newFix = (LocalQuickFixOnPsiElement)ObjectUtils.tryCast((Object)this.myFix.getFileModifierForPreview(target), LocalQuickFixOnPsiElement.class);
        return newFix == null ? null : (newFix == this.myFix ? this : new LocalQuickFixOnPsiElementAsIntentionAdapter(newFix));
    }
}

