/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixAsIntentionAdapter
implements IntentionAction {
    private final LocalQuickFix myFix;
    @NotNull
    private final ProblemDescriptor myProblemDescriptor;

    public LocalQuickFixAsIntentionAdapter(@NotNull LocalQuickFix fix2, @NotNull ProblemDescriptor problemDescriptor) {
        this.myFix = fix2;
        this.myProblemDescriptor = problemDescriptor;
    }

    @Override
    @NotNull
    public String getText() {
        return this.myFix.getName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.myFix.getFamilyName();
    }

    @NotNull
    LocalQuickFix getFix() {
        return this.myFix;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myProblemDescriptor.getStartElement() != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myFix.applyFix(project, this.myProblemDescriptor);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myFix.getElementToMakeWritable(currentFile);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }
}

