/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionWrapper
implements LocalQuickFix,
IntentionAction,
ActionClassHolder,
IntentionActionDelegate {
    private final IntentionAction myAction;
    private final VirtualFile myVirtualFile;

    public IntentionWrapper(@NotNull IntentionAction action, @NotNull PsiFile file) {
        this.myAction = action;
        this.myVirtualFile = file.getVirtualFile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myAction.getText();
    }

    @Override
    @NotNull
    public String getText() {
        return this.myAction.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.myAction.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myAction.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myAction.invoke(project, editor, file);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myAction.getElementToMakeWritable(file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myAction.startInWriteAction();
    }

    @NotNull
    public IntentionAction getAction() {
        return this.myAction;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file = PsiManager.getInstance(project).findFile(this.myVirtualFile);
        if (file != null) {
            FileEditor editor = FileEditorManager.getInstance(project).getSelectedEditor(this.myVirtualFile);
            this.myAction.invoke(project, editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null, file);
        }
    }

    @Override
    @NotNull
    public Class<?> getActionClass() {
        return this.getAction().getClass();
    }

    @Override
    @NotNull
    public IntentionAction getDelegate() {
        return this.myAction;
    }

    @Contract(value="null, _ -> null")
    public static LocalQuickFix wrapToQuickFix(@Nullable IntentionAction action, @NotNull PsiFile file) {
        if (action == null) {
            return null;
        }
        if (action instanceof LocalQuickFix) {
            return (LocalQuickFix)((Object)action);
        }
        return new IntentionWrapper(action, file);
    }

    public static LocalQuickFix @NotNull [] wrapToQuickFixes(IntentionAction @NotNull [] actions, @NotNull PsiFile file) {
        if (actions.length == 0) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = new LocalQuickFix[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            fixes[i] = IntentionWrapper.wrapToQuickFix(actions[i], file);
        }
        return fixes;
    }

    @NotNull
    public static List<LocalQuickFix> wrapToQuickFixes(@NotNull List<? extends IntentionAction> actions, @NotNull PsiFile file) {
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(actions.size());
        for (IntentionAction intentionAction : actions) {
            fixes.add(IntentionWrapper.wrapToQuickFix(intentionAction, file));
        }
        return fixes;
    }
}

