/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantNode
extends Expression {
    private final Result myValue;
    private final LookupElement[] myLookupElements;

    public ConstantNode(@NotNull String value) {
        this(new TextResult(value));
    }

    public ConstantNode(@Nullable Result value) {
        this(value, LookupElement.EMPTY_ARRAY);
    }

    private ConstantNode(@Nullable Result value, LookupElement ... lookupElements) {
        this.myValue = value;
        this.myLookupElements = lookupElements;
    }

    public ConstantNode withLookupItems(LookupElement ... lookupElements) {
        return new ConstantNode(this.myValue, lookupElements);
    }

    public ConstantNode withLookupItems(@NotNull Collection<? extends LookupElement> lookupElements) {
        return new ConstantNode(this.myValue, lookupElements.toArray(LookupElement.EMPTY_ARRAY));
    }

    public ConstantNode withLookupStrings(String ... lookupElements) {
        return new ConstantNode(this.myValue, (LookupElement[])ContainerUtil.map2Array((Object[])lookupElements, LookupElement.class, LookupElementBuilder::create));
    }

    public ConstantNode withLookupStrings(@NotNull Collection<String> lookupElements) {
        return new ConstantNode(this.myValue, (LookupElement[])ContainerUtil.map2Array(lookupElements, LookupElement.class, LookupElementBuilder::create));
    }

    @Override
    public Result calculateResult(ExpressionContext context) {
        return this.myValue;
    }

    @Override
    public Result calculateQuickResult(ExpressionContext context) {
        return this.myValue;
    }

    @Override
    public boolean requiresCommittedPSI() {
        return false;
    }

    @Override
    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myLookupElements;
    }
}

