/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.numeric;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNumberConversionIntention
implements IntentionAction {
    private static final String TITLE = "Convert number to...";
    private String myText;

    @Override
    public @IntentionName @NotNull String getText() {
        return this.myText == null ? TITLE : this.myText;
    }

    @Override
    public @IntentionFamilyName @NotNull String getFamilyName() {
        return CodeInsightBundle.message("intention.family.convert.number", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        List<NumberConverter> converters = this.getConverters(file);
        if (converters.isEmpty()) {
            return false;
        }
        NumberConversionContext context = this.getContext(file, editor);
        if (context == null) {
            return false;
        }
        Number number = context.myNumber;
        String text = context.myText;
        NumberConverter singleConverter = null;
        for (NumberConverter converter : converters) {
            String convertedText = converter.getConvertedText(text, number);
            if (convertedText == null) continue;
            if (singleConverter != null) {
                this.myText = null;
                return true;
            }
            singleConverter = converter;
        }
        if (singleConverter == null) {
            return false;
        }
        String convertedText = singleConverter.getConvertedText(text, number);
        this.myText = this.getActionName(singleConverter, convertedText);
        return true;
    }

    @Nullable
    private NumberConversionContext getContext(@NotNull PsiFile file, @NotNull Editor editor) {
        NumberConversionContext context;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        NumberConversionContext numberConversionContext = context = element == null ? null : this.extract(element);
        if (context == null && offset > 0) {
            element = file.findElementAt(offset - 1);
            context = element == null ? null : this.extract(element);
        }
        return context;
    }

    public String getActionName(NumberConverter converter, String convertedText) {
        return String.format("Convert number to %s (%s)", converter, convertedText);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        class Conversion {
            final NumberConverter myConverter;
            final String myResult;

            Conversion(NumberConverter converter, String result) {
                this.myConverter = converter;
                this.myResult = result;
            }

            void convert(NumberConversionContext context) {
                WriteCommandAction.runWriteCommandAction(context.getProject(), this.getName(), null, () -> {
                    PsiElement element = context.getElement();
                    if (element != null) {
                        AbstractNumberConversionIntention.this.replace(element, this.myResult);
                    }
                }, file);
            }

            private String getName() {
                return AbstractNumberConversionIntention.this.getActionName(this.myConverter, this.myResult);
            }

            public String toString() {
                return StringUtil.capitalize((String)this.myConverter.toString()) + " (" + this.myResult + ")";
            }
        }
        List<NumberConverter> converters = this.getConverters(file);
        if (converters.isEmpty()) {
            return;
        }
        NumberConversionContext context = this.getContext(file, editor);
        if (context == null) {
            return;
        }
        Number number = context.myNumber;
        String text = context.myText;
        List list = this.getConverters(file).stream().map(converter -> new Conversion((NumberConverter)converter, converter.getConvertedText(text, number))).filter(conversion -> conversion.myResult != null).collect(Collectors.toList());
        if (this.myText != null) {
            list.stream().filter(c -> ((Conversion)c).getName().equals(this.myText)).findFirst().ifPresent(conversion -> conversion.convert(context));
            return;
        }
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(list).setSelectionMode(0).setAccessibleName(TITLE).setTitle(StringUtil.wordsToBeginFromUpperCase((String)TITLE)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(conversion -> conversion.convert(context)).createPopup();
        popup.showInBestPositionFor(editor);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    @Contract(pure=true)
    protected abstract NumberConversionContext extract(@NotNull PsiElement var1);

    @NotNull
    @Contract(pure=true)
    protected abstract List<NumberConverter> getConverters(@NotNull PsiFile var1);

    protected abstract void replace(PsiElement var1, String var2);

    protected static class NumberConversionContext {
        @NotNull
        final SmartPsiElementPointer<PsiElement> myElement;
        @NotNull
        final Number myNumber;
        @NotNull
        final String myText;
        final boolean myNegated;

        public NumberConversionContext(@NotNull PsiElement element, @NotNull Number number, @NotNull String text, boolean negated) {
            this.myElement = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
            this.myNumber = number;
            this.myText = text;
            this.myNegated = negated;
        }

        @Nullable
        PsiElement getElement() {
            return this.myElement.getElement();
        }

        @NotNull
        public Project getProject() {
            return this.myElement.getProject();
        }
    }
}

