/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseElementAtCaretIntentionAction
extends BaseIntentionAction {
    private volatile boolean useElementToTheLeft;

    @Override
    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement elementToTheLeft;
        if (!this.checkFile(file)) {
            return false;
        }
        this.useElementToTheLeft = false;
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementToTheRight = file.findElementAt(offset);
        if (elementToTheRight != null && this.isAvailable(project, editor, elementToTheRight)) {
            return true;
        }
        PsiElement psiElement = elementToTheLeft = offset > 0 ? file.findElementAt(offset - 1) : null;
        if (elementToTheLeft != null && this.isAvailable(project, editor, elementToTheLeft)) {
            this.useElementToTheLeft = true;
            return true;
        }
        return false;
    }

    protected boolean checkFile(@NotNull PsiFile file) {
        return BaseElementAtCaretIntentionAction.canModify(file);
    }

    public abstract boolean isAvailable(@NotNull Project var1, Editor var2, @NotNull PsiElement var3);

    @Override
    public final void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(this.useElementToTheLeft ? offset - 1 : offset);
        if (element == null) {
            return;
        }
        this.invoke(project, editor, element);
    }

    public abstract void invoke(@NotNull Project var1, Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;
}

