/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InlayParameterHintsProvider {
    @NotNull
    default public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        return Collections.emptyList();
    }

    @NotNull
    default public List<InlayInfo> getParameterHints(@NotNull PsiElement element, @NotNull PsiFile file) {
        return this.getParameterHints(element);
    }

    @Nullable
    default public HintInfo getHintInfo(@NotNull PsiElement element) {
        return null;
    }

    @Nullable
    default public HintInfo getHintInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        return this.getHintInfo(element);
    }

    @NotNull
    public Set<String> getDefaultBlackList();

    @Nullable
    default public Language getBlackListDependencyLanguage() {
        return null;
    }

    @NotNull
    default public List<Option> getSupportedOptions() {
        return ContainerUtil.emptyList();
    }

    default public boolean isBlackListSupported() {
        return true;
    }

    default public String getBlacklistExplanationHTML() {
        return CodeInsightBundle.message("inlay.hints.blacklist.pattern.explanation", new Object[0]);
    }

    @NotNull
    default public String getInlayPresentation(@NotNull String inlayText) {
        return inlayText + ":";
    }

    default public boolean canShowHintsWhenDisabled() {
        return false;
    }

    default public String getSettingsPreview() {
        return null;
    }

    default public boolean isExhaustive() {
        return false;
    }

    default public String getMainCheckboxText() {
        return CodeInsightBundle.message("settings.inlay.show.parameter.hints", new Object[0]);
    }

    @NotNull
    default public SyntaxTraverser<PsiElement> createTraversal(@NotNull PsiElement root) {
        return SyntaxTraverser.psiTraverser(root);
    }
}

