/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProblemHighlightFilter {
    public static final ExtensionPointName<ProblemHighlightFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.problemHighlightFilter");

    public abstract boolean shouldHighlight(@NotNull PsiFile var1);

    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        return this.shouldHighlight(psiFile);
    }

    public static boolean shouldHighlightFile(@Nullable PsiFile psiFile) {
        return ProblemHighlightFilter.shouldProcess(psiFile, true);
    }

    public static boolean shouldProcessFileInBatch(@Nullable PsiFile psiFile) {
        return ProblemHighlightFilter.shouldProcess(psiFile, false);
    }

    private static boolean shouldProcess(PsiFile psiFile, boolean onTheFly) {
        if (psiFile == null) {
            return true;
        }
        return EP_NAME.getExtensionList().stream().noneMatch(filter -> onTheFly ? !filter.shouldHighlight(psiFile) : !filter.shouldProcessInBatch(psiFile));
    }
}

