/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonCodeAnalyzer {
    public static final Topic<DaemonListener> DAEMON_EVENT_TOPIC = new Topic("DAEMON_EVENT_TOPIC", DaemonListener.class, Topic.BroadcastDirection.NONE);

    public static DaemonCodeAnalyzer getInstance(Project project) {
        return (DaemonCodeAnalyzer)project.getComponent(DaemonCodeAnalyzer.class);
    }

    public abstract void settingsChanged();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public void updateVisibleHighlighters(@NotNull Editor editor) {
        DeprecatedMethodException.report((String)"Please remove usages of this method deprecated eons ago");
    }

    public abstract void setUpdateByTimerEnabled(boolean var1);

    public abstract void disableUpdateByTimer(@NotNull Disposable var1);

    public abstract boolean isHighlightingAvailable(@Nullable PsiFile var1);

    public abstract void setImportHintsEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract void resetImportHintsEnabledForProject();

    public abstract void setHighlightingEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract boolean isImportHintsEnabled(@NotNull PsiFile var1);

    public abstract boolean isAutohintsAvailable(@Nullable PsiFile var1);

    public abstract void restart();

    public abstract void restart(@NotNull PsiFile var1);

    public abstract void autoImportReferenceAtCursor(@NotNull Editor var1, @NotNull PsiFile var2);

    @Deprecated
    public static abstract class DaemonListenerAdapter
    implements DaemonListener {
    }

    public static interface DaemonListener {
        default public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        }

        default public void daemonFinished() {
        }

        default public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
            this.daemonFinished();
        }

        default public void daemonCancelEventOccurred(@NotNull String reason) {
        }

        @ApiStatus.Internal
        default public void daemonAnnotatorStatisticsGenerated(@NotNull AnnotationSession session, @NotNull Collection<? extends AnnotatorStatistics> statistics, @NotNull PsiFile file) {
        }

        @ApiStatus.Internal
        public static class AnnotatorStatistics {
            public final Annotator annotator;
            public long annotatorStartStamp;
            public long firstAnnotationStamp;
            public Annotation firstAnnotation;
            public long lastAnnotationStamp;
            public Annotation lastAnnotation;
            public long annotatorFinishStamp;

            AnnotatorStatistics(@NotNull Annotator annotator) {
                this.annotator = annotator;
            }
        }
    }
}

