/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Instruction {
    public static final Instruction[] EMPTY_ARRAY = new Instruction[0];

    @Nullable
    public PsiElement getElement();

    @NotNull
    public Collection<Instruction> allSucc();

    @NotNull
    public Collection<Instruction> allPred();

    public int num();

    @NotNull
    public String getElementPresentation();

    default public void addSucc(@NotNull Instruction endInstruction) {
        if (!this.allSucc().contains(endInstruction)) {
            this.allSucc().add(endInstruction);
        }
    }

    default public void addPred(@NotNull Instruction beginInstruction) {
        if (!this.allPred().contains(beginInstruction)) {
            this.allPred().add(beginInstruction);
        }
    }

    default public void replacePred(@NotNull Instruction oldInstruction, @NotNull Collection<? extends Instruction> newInstructions) {
        newInstructions.forEach(el -> this.addPred((Instruction)el));
        this.allPred().remove(oldInstruction);
    }

    default public void replaceSucc(@NotNull Instruction oldInstruction, @NotNull Collection<? extends Instruction> newInstructions) {
        newInstructions.forEach(el -> this.addSucc((Instruction)el));
        this.allSucc().remove(oldInstruction);
    }
}

