/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class UnfocusedNameIdentifier
extends CompletionConfidence {
    @Override
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof PsiNameIdentifierOwner) {
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)parent).getNameIdentifier();
            if (nameIdentifier == position) {
                return ThreeState.NO;
            }
            if (nameIdentifier != null && position.getTextRange().equals((Object)nameIdentifier.getTextRange())) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }
}

