/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PlainPrefixMatcher
extends PrefixMatcher {
    private final boolean myPrefixMatchesOnly;

    public PlainPrefixMatcher(@NotNull String prefix) {
        this(prefix, false);
    }

    public PlainPrefixMatcher(@NotNull String prefix, boolean prefixMatchesOnly) {
        super(prefix);
        this.myPrefixMatchesOnly = prefixMatchesOnly;
    }

    @Override
    public boolean isStartMatch(@NotNull String name) {
        return StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
    }

    @Override
    public boolean prefixMatches(@NotNull String name) {
        if (this.myPrefixMatchesOnly) {
            return this.isStartMatch(name);
        }
        return StringUtil.containsIgnoreCase((String)name, (String)this.getPrefix());
    }

    @Override
    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        return new PlainPrefixMatcher(prefix, this.myPrefixMatchesOnly);
    }
}

