/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class OffsetMap
implements Disposable {
    private final Document myDocument;
    private final Map<OffsetKey, RangeMarker> myMap = new THashMap();
    private final Set<OffsetKey> myModified = new THashSet();
    private volatile boolean myDisposed;

    public OffsetMap(Document document) {
        this.myDocument = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffset(OffsetKey key) {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            RangeMarker marker = this.myMap.get(key);
            if (marker == null) {
                throw new IllegalArgumentException("Offset " + key + " is not registered");
            }
            if (!marker.isValid()) {
                this.removeOffset(key);
                throw new IllegalStateException("Offset " + key + " is invalid: " + marker + ", document.valid=" + (!(this.myDocument instanceof DocumentWindow) || ((DocumentWindow)this.myDocument).isValid()));
            }
            int endOffset = marker.getEndOffset();
            if (marker.getStartOffset() != endOffset) {
                this.saveOffset(key, endOffset, false);
            }
            return endOffset;
        }
    }

    public boolean containsOffset(OffsetKey key) {
        RangeMarker marker = this.myMap.get(key);
        return marker != null && marker.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOffset(OffsetKey key, int offset) {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            if (offset < 0) {
                this.removeOffset(key);
                return;
            }
            this.saveOffset(key, offset, true);
        }
    }

    private void saveOffset(OffsetKey key, int offset, boolean externally) {
        RangeMarker old;
        assert (!this.myDisposed);
        if (externally && this.myMap.containsKey(key)) {
            this.myModified.add(key);
        }
        if ((old = this.myMap.get(key)) != null) {
            old.dispose();
        }
        RangeMarker marker = this.myDocument.createRangeMarker(offset, offset);
        marker.setGreedyToRight(key.isMovableToRight());
        this.myMap.put(key, marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffset(OffsetKey key) {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            ProgressManager.checkCanceled();
            assert (!this.myDisposed);
            this.myModified.add(key);
            RangeMarker old = this.myMap.get(key);
            if (old != null) {
                old.dispose();
            }
            this.myMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OffsetKey> getAllOffsets() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            ProgressManager.checkCanceled();
            assert (!this.myDisposed);
            return ContainerUtil.filter(this.myMap.keySet(), this::containsOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            StringBuilder builder = new StringBuilder("OffsetMap:");
            for (OffsetKey key : this.myMap.keySet()) {
                builder.append(key).append("->").append(this.myMap.get(key)).append(";");
            }
            return builder.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasModified(OffsetKey key) {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            return this.myModified.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            this.myDisposed = true;
            for (RangeMarker rangeMarker : this.myMap.values()) {
                rangeMarker.dispose();
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @ApiStatus.Internal
    @NotNull
    public OffsetMap copyOffsets(@NotNull Document anotherDocument) {
        assert (anotherDocument.getTextLength() == this.myDocument.getTextLength());
        return this.mapOffsets(anotherDocument, Function.identity());
    }

    @ApiStatus.Internal
    @NotNull
    public OffsetMap mapOffsets(@NotNull Document anotherDocument, @NotNull Function<Integer, Integer> mapping) {
        OffsetMap result = new OffsetMap(anotherDocument);
        for (OffsetKey key : this.getAllOffsets()) {
            result.addOffset(key, mapping.apply(this.getOffset(key)));
        }
        return result;
    }
}

