/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.MetaLanguage;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CompletionExtension<T>
extends LanguageExtension<T> {
    public CompletionExtension(String epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        return this.buildExtensions(this.getAllBaseLanguageIdsWithAny(key));
    }

    @Override
    public void invalidateCacheForExtension(String key) {
        super.invalidateCacheForExtension(key);
        this.clearCache();
        if ("any".equals(key)) {
            for (Language language : Language.getRegisteredLanguages()) {
                super.invalidateCacheForExtension(this.keyToString(language));
            }
        }
    }

    @NotNull
    private Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        THashSet allowed = new THashSet();
        while (key != null) {
            allowed.add(this.keyToString(key));
            for (MetaLanguage metaLanguage : MetaLanguage.all()) {
                if (!metaLanguage.matchesLanguage(key)) continue;
                allowed.add(metaLanguage.getID());
            }
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        return allowed;
    }
}

