/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.breadcrumbs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBreadcrumbsCollector {
    public static final ProjectExtensionPointName<FileBreadcrumbsCollector> EP_NAME = new ProjectExtensionPointName("com.intellij.fileBreadcrumbsCollector");

    public abstract boolean handlesFile(@NotNull VirtualFile var1);

    public boolean isShownForFile(@NotNull Editor editor, @NotNull VirtualFile file) {
        return true;
    }

    public abstract void watchForChanges(@NotNull VirtualFile var1, @NotNull Editor var2, @NotNull Disposable var3, @NotNull Runnable var4);

    @NotNull
    public abstract Iterable<? extends Crumb> computeCrumbs(@NotNull VirtualFile var1, @NotNull Document var2, int var3, @Nullable Boolean var4);

    public static FileBreadcrumbsCollector findBreadcrumbsCollector(Project project, VirtualFile file) {
        if (file != null) {
            for (FileBreadcrumbsCollector extension : EP_NAME.getExtensions((AreaInstance)project)) {
                if (!extension.handlesFile(file)) continue;
                return extension;
            }
        }
        return (FileBreadcrumbsCollector)ContainerUtil.getLastItem((List)EP_NAME.getPoint((AreaInstance)project).getExtensionList());
    }
}

