/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualGuidesAccessor
extends CodeStylePropertyAccessor<List<Integer>> {
    private final CodeStyleSettings mySettings;
    @Nullable
    private final Language myLanguage;
    public static final String VISUAL_GUIDES_PROPERTY_NAME = "visual_guides";

    VisualGuidesAccessor(@NotNull CodeStyleSettings settings, @Nullable Language language) {
        this.mySettings = settings;
        this.myLanguage = language;
    }

    @Override
    public boolean set(@NotNull List<Integer> extVal) {
        if (this.myLanguage != null) {
            this.mySettings.setSoftMargins(this.myLanguage, extVal);
        } else {
            this.mySettings.setDefaultSoftMargins(extVal);
        }
        return true;
    }

    @Override
    @Nullable
    public List<Integer> get() {
        List<Integer> values = this.myLanguage != null ? this.mySettings.getCommonSettings(this.myLanguage).getSoftMargins() : this.mySettings.getDefaultSoftMargins();
        return !values.isEmpty() ? values : null;
    }

    @Override
    protected List<Integer> parseString(@NotNull String string) {
        return CodeStylePropertiesUtil.getValueList(string).stream().map(s -> VisualGuidesAccessor.safeToInt(s)).filter(integer -> integer >= 0).collect(Collectors.toList());
    }

    @Override
    @Nullable
    protected String valueToString(@NotNull List<Integer> value) {
        return CodeStylePropertiesUtil.toCommaSeparatedString(value);
    }

    private static int safeToInt(@NotNull String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public String getPropertyName() {
        return VISUAL_GUIDES_PROPERTY_NAME;
    }
}

