/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerAccessor
extends CodeStyleFieldAccessor<Integer, Integer> {
    public IntegerAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Override
    @Nullable
    protected Integer parseString(@NotNull String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    @Nullable
    protected String valueToString(@NotNull Integer value) {
        return String.valueOf(value);
    }

    @Override
    protected Integer fromExternal(@NotNull Integer i) {
        return i;
    }

    @Override
    @NotNull
    protected Integer toExternal(@NotNull Integer value) {
        return value;
    }

    @Override
    protected boolean isEmpty(@NotNull Integer value) {
        return value < 0;
    }
}

