/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.FieldAccessorFactory;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCodeStylePropertyMapper {
    @NotNull
    private final CodeStyleSettings myRootSettings;
    private final AtomicNotNullLazyValue<Map<String, CodeStylePropertyAccessor<?>>> myAccessorMap;

    public AbstractCodeStylePropertyMapper(@NotNull CodeStyleSettings settings) {
        this.myRootSettings = settings;
        this.myAccessorMap = AtomicNotNullLazyValue.createValue(() -> this.createMap());
    }

    public List<String> enumProperties() {
        return this.getAccessorMap().keySet().stream().sorted().collect(Collectors.toList());
    }

    private Map<String, CodeStylePropertyAccessor<?>> createMap() {
        Object2ObjectOpenHashMap accessorMap = new Object2ObjectOpenHashMap();
        for (CodeStyleObjectDescriptor descriptor : this.getSupportedFields()) {
            this.addAccessorsFor((Map<String, CodeStylePropertyAccessor<?>>)accessorMap, descriptor.getCodeStyleObject(), descriptor.getSupportedFields());
        }
        this.addAdditionalAccessors((Map<String, CodeStylePropertyAccessor<?>>)accessorMap);
        return accessorMap;
    }

    @NotNull
    protected abstract List<CodeStyleObjectDescriptor> getSupportedFields();

    protected void addAdditionalAccessors(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap) {
    }

    private void addAccessorsFor(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap, @NotNull Object codeStyleObject, @Nullable Set<String> supportedFields) {
        Class<?> codeStyleClass = AbstractCodeStylePropertyMapper.getObjectStorageClass(codeStyleObject);
        for (Field field : this.getCodeStyleFields(codeStyleClass)) {
            CodeStylePropertyAccessor<?> accessor;
            String fieldName = field.getName();
            if (supportedFields != null && !supportedFields.contains(fieldName) || (accessor = this.getAccessor(codeStyleObject, field)) == null || accessor.isIgnorable()) continue;
            accessorMap.put(accessor.getPropertyName(), accessor);
        }
    }

    private static Class<?> getObjectStorageClass(@NotNull Object codeStyleObject) {
        Class<?> objectClass = codeStyleObject.getClass();
        if (CodeStyleSettings.class.isAssignableFrom(objectClass)) {
            return CodeStyleSettings.class;
        }
        return objectClass;
    }

    @Nullable
    protected CodeStylePropertyAccessor<?> getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        return new FieldAccessorFactory(field).createAccessor(codeStyleObject);
    }

    private List<Field> getCodeStyleFields(Class<?> codeStyleClass) {
        Field[] allFields;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : allFields = this.useDeclaredFields() ? codeStyleClass.getDeclaredFields() : codeStyleClass.getFields()) {
            if (!AbstractCodeStylePropertyMapper.isPublic(field) || AbstractCodeStylePropertyMapper.isFinal(field)) continue;
            fields.add(field);
        }
        return fields;
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    protected CodeStyleSettings getRootSettings() {
        return this.myRootSettings;
    }

    @NotNull
    private Map<String, CodeStylePropertyAccessor<?>> getAccessorMap() {
        return (Map)this.myAccessorMap.getValue();
    }

    public CodeStylePropertyAccessor<?> getAccessor(@NotNull String property) {
        return (CodeStylePropertyAccessor)((Map)this.myAccessorMap.getValue()).get(property);
    }

    protected boolean useDeclaredFields() {
        return false;
    }

    @NotNull
    public abstract String getLanguageDomainId();

    @Deprecated
    public boolean containsProperty(@NotNull String name) {
        return this.getAccessorMap().containsKey(name);
    }

    @Nullable
    public abstract String getPropertyDescription(@NotNull String var1);

    protected static final class CodeStyleObjectDescriptor {
        private final Object myObject;
        private final Set<String> mySupportedFields;

        public CodeStyleObjectDescriptor(@NotNull Object codeStyleObject, @Nullable Set<String> fields) {
            this.myObject = codeStyleObject;
            this.mySupportedFields = fields;
        }

        @NotNull
        private Object getCodeStyleObject() {
            return this.myObject;
        }

        @Nullable
        private Set<String> getSupportedFields() {
            return this.mySupportedFields;
        }
    }
}

