/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.components.fields.IntegerField;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentOptionsEditor
extends OptionGroup
implements CodeStyleSettingsCustomizable {
    @Deprecated
    protected JTextField myIndentField;
    @Deprecated
    protected JCheckBox myCbUseTab;
    @Deprecated
    protected JTextField myTabSizeField;
    @Deprecated
    protected JLabel myTabSizeLabel;
    @Deprecated
    protected JLabel myIndentLabel;
    @Nullable
    private final LanguageCodeStyleSettingsProvider myProvider;

    public IndentOptionsEditor() {
        this((LanguageCodeStyleSettingsProvider)null);
    }

    public IndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
        this.myProvider = provider;
    }

    @Override
    public JPanel createPanel() {
        this.addComponents();
        if (this.myProvider != null) {
            this.myProvider.customizeSettings(this, LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS);
        }
        return super.createPanel();
    }

    protected void addComponents() {
        this.addTabOptions();
        this.addTabSizeField();
        this.addIndentField();
    }

    protected void addIndentField() {
        this.myIndentField = this.createIndentTextField(IndentOptionsEditor.getIndentLabel(), 0, 32, 4);
        this.myIndentLabel = new JLabel(IndentOptionsEditor.getIndentLabel());
        this.add((JComponent)this.myIndentLabel, this.myIndentField);
    }

    protected void addTabSizeField() {
        this.myTabSizeField = this.createIndentTextField(IndentOptionsEditor.getTabSizeLabel(), 1, 16, 4);
        this.myTabSizeLabel = new JLabel(IndentOptionsEditor.getTabSizeLabel());
        this.add((JComponent)this.myTabSizeLabel, this.myTabSizeField);
    }

    @Deprecated
    protected JTextField createIndentTextField() {
        return this.createIndentTextField(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    }

    protected IntegerField createIndentTextField(@Nullable String valueName, int minSize, int maxSize, int defaultValue) {
        IntegerField field = new IntegerField(valueName, minSize, maxSize);
        field.setDefaultValue(defaultValue);
        field.setColumns(4);
        if (defaultValue < 0) {
            field.setCanBeEmpty(true);
        }
        field.setMinimumSize(field.getPreferredSize());
        return field;
    }

    protected void addTabOptions() {
        this.myCbUseTab = new JCheckBox(ApplicationBundle.message("checkbox.indent.use.tab.character", new Object[0]));
        this.add(this.myCbUseTab);
    }

    @Override
    public void showAllStandardOptions() {
        this.setVisible(true);
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        this.setVisible(false);
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.IndentOption.INDENT_SIZE.toString().equals(optionName)) {
                this.myIndentLabel.setVisible(true);
                this.myIndentField.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.IndentOption.TAB_SIZE.toString().equals(optionName)) {
                this.myTabSizeField.setVisible(true);
                this.myTabSizeLabel.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.IndentOption.USE_TAB_CHARACTER.toString().equals(optionName)) continue;
            this.myCbUseTab.setVisible(true);
        }
    }

    protected static boolean isFieldModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    protected static boolean isFieldModified(JTextField textField, int value) {
        if (textField instanceof IntegerField) {
            return ((IntegerField)textField).getValue() != value;
        }
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = IndentOptionsEditor.isFieldModified(this.myTabSizeField, options.TAB_SIZE);
        isModified |= IndentOptionsEditor.isFieldModified(this.myCbUseTab, options.USE_TAB_CHARACTER);
        return isModified |= IndentOptionsEditor.isFieldModified(this.myIndentField, options.INDENT_SIZE);
    }

    protected int getUIIndent() {
        assert (this.myIndentField instanceof IntegerField);
        return ((IntegerField)this.myIndentField).getValue();
    }

    protected int getUITabSize() {
        assert (this.myTabSizeField instanceof IntegerField);
        return ((IntegerField)this.myTabSizeField).getValue();
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        options.INDENT_SIZE = this.getUIIndent();
        options.TAB_SIZE = this.getUITabSize();
        options.USE_TAB_CHARACTER = this.myCbUseTab.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        ((IntegerField)this.myTabSizeField).setValue(options.TAB_SIZE);
        this.myCbUseTab.setSelected(options.USE_TAB_CHARACTER);
        ((IntegerField)this.myIndentField).setValue(options.INDENT_SIZE);
    }

    @Deprecated
    protected int getFieldValue(JTextField field, int minValue, int defValue) {
        if (field instanceof IntegerField) {
            return ((IntegerField)field).getValue();
        }
        try {
            return Math.max(Integer.parseInt(field.getText()), minValue);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public void setEnabled(boolean enabled) {
        this.myIndentField.setEnabled(enabled);
        this.myIndentLabel.setEnabled(enabled);
        this.myTabSizeField.setEnabled(enabled);
        this.myTabSizeLabel.setEnabled(enabled);
        this.myCbUseTab.setEnabled(enabled);
    }

    protected void setVisible(boolean visible) {
        this.myIndentField.setVisible(visible);
        this.myIndentLabel.setVisible(visible);
        this.myTabSizeField.setVisible(visible);
        this.myTabSizeLabel.setVisible(visible);
        this.myCbUseTab.setVisible(visible);
    }

    private static String getIndentLabel() {
        return ApplicationBundle.message("editbox.indent.indent", new Object[0]);
    }

    private static String getTabSizeLabel() {
        return ApplicationBundle.message("editbox.indent.tab.size", new Object[0]);
    }
}

