/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.psi.codeStyle.CodeStyleConstraints;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContinuationOption
implements CodeStyleConstraints {
    @Nullable
    private IntegerField myField;
    private boolean mySupported;
    private final String myName;
    private final Function<? super CommonCodeStyleSettings.IndentOptions, Integer> myGetter;
    private final BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> mySetter;
    private final int myDefaultValue;
    private JLabel myLabel;

    public ContinuationOption(String name, Function<? super CommonCodeStyleSettings.IndentOptions, Integer> getter, BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> setter, int defaultValue) {
        this.myName = name;
        this.myGetter = getter;
        this.mySetter = setter;
        this.myDefaultValue = defaultValue;
    }

    public void addToEditor(@NotNull IndentOptionsEditor editor) {
        if (this.mySupported) {
            this.myLabel = new JLabel(this.myName);
            this.myField = editor.createIndentTextField("Continuation indent", 0, 32, this.myDefaultValue);
            editor.add((JComponent)this.myLabel, this.myField);
        }
    }

    public void setSupported(boolean supported) {
        this.mySupported = supported;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.mySupported && this.myField != null && this.myLabel != null) {
            this.myField.setEnabled(isEnabled);
            this.myLabel.setEnabled(isEnabled);
        }
    }

    public boolean isModified(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        return this.mySupported && this.myField != null && !this.myField.getValue().equals(this.myGetter.apply(options));
    }

    public void reset(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (this.mySupported && this.myField != null) {
            this.myField.setValue(this.myGetter.apply(options));
            this.setDefaultValueToDisplay(options.CONTINUATION_INDENT_SIZE);
        }
    }

    public void apply(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (this.mySupported && this.myField != null) {
            this.mySetter.accept(options, this.myField.getValue());
        }
    }

    public void addListener(@NotNull ValueEditor.Listener<Integer> listener2) {
        assert (this.myField != null);
        this.myField.getValueEditor().addListener(listener2);
    }

    public void setDefaultValueToDisplay(int value) {
        if (this.mySupported && this.myField != null) {
            this.myField.setDefaultValueText(Integer.toString(value));
        }
    }

    public void setVisible(boolean visible) {
        if (this.myField != null && this.myLabel != null) {
            this.myLabel.setVisible(visible);
            this.myField.setVisible(visible);
        }
    }
}

