/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIFailureException;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0016\u001a\f\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u0006\u001a\f\u0010\u0017\u001a\u00020\u0002*\u0004\u0018\u00010\u0010\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"jdiClass", "Lcom/sun/jdi/ClassObjectReference;", "Lorg/jetbrains/eval4j/Value;", "getJdiClass", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ClassObjectReference;", "jdiObj", "Lcom/sun/jdi/ObjectReference;", "getJdiObj", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ObjectReference;", "makeInitialFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "arguments", "", "asJdiValue", "Lcom/sun/jdi/Value;", "vm", "Lcom/sun/jdi/VirtualMachine;", "expectedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "asType", "Lcom/sun/jdi/Type;", "asValue", "Lorg/jetbrains/eval4j/ObjectValue;", "kotlin.eval4j"})
public final class JdiValuesKt {
    @NotNull
    public static final Frame<Value> makeInitialFrame(@NotNull MethodNode methodNode, @NotNull List<? extends Value> arguments) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        boolean isStatic = (methodNode.access & 8) != 0;
        Type[] params = Type.getArgumentTypes((String)methodNode.desc);
        boolean bl = arguments.size() == (isStatic ? params.length : params.length + 1);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Wrong number of arguments for " + methodNode + ": " + arguments;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Frame frame = new Frame(methodNode.maxLocals, methodNode.maxStack);
        Type type = Type.getReturnType((String)methodNode.desc);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.getReturnType(methodNode.desc)");
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ValuesKt.makeNotInitializedValue(type));
        int index = 0;
        for (Value value : arguments) {
            frame.setLocal(index++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (value.getSize() != 2) continue;
            frame.setLocal(index++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        while (index < methodNode.maxLocals) {
            frame.setLocal(index++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        return frame;
    }

    @NotNull
    public static final ObjectValue asValue(@Nullable ObjectReference $this$asValue) {
        ObjectValue objectValue;
        ObjectReference objectReference = $this$asValue;
        if (objectReference == null) {
            objectValue = ValuesKt.getNULL_VALUE();
        } else {
            com.sun.jdi.Type type = $this$asValue.type();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type()");
            objectValue = new ObjectValue($this$asValue, JdiValuesKt.asType(type));
        }
        return objectValue;
    }

    @NotNull
    public static final Value asValue(@Nullable com.sun.jdi.Value $this$asValue) {
        Value value;
        com.sun.jdi.Value value2 = $this$asValue;
        if (value2 == null) {
            value = ValuesKt.getNULL_VALUE();
        } else if (value2 instanceof VoidValue) {
            value = VOID_VALUE.INSTANCE;
        } else if (value2 instanceof BooleanValue) {
            int n = ((BooleanValue)$this$asValue).intValue();
            Type type = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.BOOLEAN_TYPE");
            value = new IntValue(n, type);
        } else if (value2 instanceof ByteValue) {
            int n = ((ByteValue)$this$asValue).intValue();
            Type type = Type.BYTE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.BYTE_TYPE");
            value = new IntValue(n, type);
        } else if (value2 instanceof ShortValue) {
            int n = ((ShortValue)$this$asValue).intValue();
            Type type = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.SHORT_TYPE");
            value = new IntValue(n, type);
        } else if (value2 instanceof CharValue) {
            int n = ((CharValue)$this$asValue).intValue();
            Type type = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.CHAR_TYPE");
            value = new IntValue(n, type);
        } else if (value2 instanceof IntegerValue) {
            int n = ((IntegerValue)$this$asValue).intValue();
            Type type = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.INT_TYPE");
            value = new IntValue(n, type);
        } else if (value2 instanceof com.sun.jdi.LongValue) {
            value = new LongValue(((com.sun.jdi.LongValue)$this$asValue).longValue());
        } else if (value2 instanceof com.sun.jdi.FloatValue) {
            value = new FloatValue(((com.sun.jdi.FloatValue)$this$asValue).floatValue());
        } else if (value2 instanceof com.sun.jdi.DoubleValue) {
            value = new DoubleValue(((com.sun.jdi.DoubleValue)$this$asValue).doubleValue());
        } else if (value2 instanceof ObjectReference) {
            value = JdiValuesKt.asValue((ObjectReference)$this$asValue);
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $this$asValue, null, 2, null);
        }
        return value;
    }

    @NotNull
    public static final Type asType(@NotNull com.sun.jdi.Type $this$asType) {
        Intrinsics.checkNotNullParameter((Object)$this$asType, (String)"$this$asType");
        Type type = Type.getType((String)$this$asType.signature());
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.getType(this.signature())");
        return type;
    }

    @Nullable
    public static final ObjectReference getJdiObj(@NotNull Value $this$jdiObj) {
        Intrinsics.checkNotNullParameter((Object)$this$jdiObj, (String)"$this$jdiObj");
        return (ObjectReference)ValuesKt.obj$default($this$jdiObj, null, 1, null);
    }

    @Nullable
    public static final ClassObjectReference getJdiClass(@NotNull Value $this$jdiClass) {
        Intrinsics.checkNotNullParameter((Object)$this$jdiClass, (String)"$this$jdiClass");
        return (ClassObjectReference)JdiValuesKt.getJdiObj($this$jdiClass);
    }

    @Nullable
    public static final com.sun.jdi.Value asJdiValue(@NotNull Value $this$asJdiValue, @NotNull VirtualMachine vm, @NotNull Type expectedType) {
        com.sun.jdi.Value value;
        Intrinsics.checkNotNullParameter((Object)$this$asJdiValue, (String)"$this$asJdiValue");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Value value2 = $this$asJdiValue;
        if (Intrinsics.areEqual((Object)value2, (Object)ValuesKt.getNULL_VALUE())) {
            value = null;
        } else if (Intrinsics.areEqual((Object)value2, (Object)VOID_VALUE.INSTANCE)) {
            value = vm.mirrorOfVoid();
        } else if (value2 instanceof IntValue) {
            PrimitiveValue primitiveValue;
            Type type = expectedType;
            if (Intrinsics.areEqual((Object)type, (Object)Type.BOOLEAN_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getBoolean($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type, (Object)Type.BYTE_TYPE)) {
                primitiveValue = vm.mirrorOf((byte)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type, (Object)Type.SHORT_TYPE)) {
                primitiveValue = vm.mirrorOf((short)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type, (Object)Type.CHAR_TYPE)) {
                primitiveValue = vm.mirrorOf((char)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type, (Object)Type.INT_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getInt($this$asJdiValue));
            } else {
                throw (Throwable)new JDIFailureException("Unknown value type: " + $this$asJdiValue, null, 2, null);
            }
            value = primitiveValue;
        } else if (value2 instanceof LongValue) {
            value = vm.mirrorOf(((Number)((LongValue)$this$asJdiValue).getValue()).longValue());
        } else if (value2 instanceof FloatValue) {
            value = vm.mirrorOf(((Number)((FloatValue)$this$asJdiValue).getValue()).floatValue());
        } else if (value2 instanceof DoubleValue) {
            value = vm.mirrorOf(((Number)((DoubleValue)$this$asJdiValue).getValue()).doubleValue());
        } else if (value2 instanceof ObjectValue) {
            Object v = ((ObjectValue)$this$asJdiValue).getValue();
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value = (ObjectReference)v;
        } else if (value2 instanceof NewObjectValue) {
            Object object = ValuesKt.obj$default($this$asJdiValue, null, 1, null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value = (ObjectReference)object;
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $this$asJdiValue, null, 2, null);
        }
        return value;
    }
}

