/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.AbstractUpdateCopyright;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public abstract class UpdatePsiFileCopyright
extends AbstractUpdateCopyright {
    private static final Logger LOG = Logger.getInstance(UpdatePsiFileCopyright.class);
    private final CopyrightProfile myOptions;
    private final PsiFile file;
    private final LanguageOptions langOpts;
    private final TreeSet<CommentAction> actions = new TreeSet();
    private static final Logger logger = Logger.getInstance((String)UpdatePsiFileCopyright.class.getName());

    protected UpdatePsiFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
        super(project, module, root, options);
        this.myOptions = options;
        PsiManager manager = PsiManager.getInstance((Project)project);
        this.file = manager.findFile(root);
        FileType type = root.getFileType();
        this.langOpts = CopyrightManager.getInstance(project).getOptions().getMergedOptions(type.getName());
    }

    @Override
    public void prepare() {
        if (this.file == null) {
            logger.info("No file for root: " + this.getRoot());
            return;
        }
        if (this.accept()) {
            this.scanFile();
        }
    }

    @Override
    public void complete() throws Exception {
        this.complete(true);
    }

    public void complete(boolean allowReplacement) throws Exception {
        if (this.file == null) {
            logger.info("No file for root: " + this.getRoot());
            return;
        }
        if (this.accept()) {
            this.processActions(allowReplacement);
        }
    }

    protected boolean accept() {
        return !(this.file instanceof PsiPlainTextFile);
    }

    protected abstract void scanFile();

    protected void checkComments(PsiElement first, PsiElement last, boolean commentHere) {
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        this.collectComments(first, last, comments);
        this.checkComments(last, commentHere, comments);
    }

    protected void collectComments(PsiElement first, PsiElement last, List<PsiComment> comments) {
        if (first == last && first instanceof PsiComment) {
            comments.add((PsiComment)first);
            return;
        }
        PsiElement elem = first;
        while (elem != last && elem != null) {
            if (elem instanceof PsiComment) {
                comments.add((PsiComment)elem);
                logger.debug("found comment");
            }
            elem = this.getNextSibling(elem);
        }
    }

    protected void checkComments(PsiElement last, boolean commentHere, List<PsiComment> comments) {
        try {
            String keyword = this.myOptions.getKeyword();
            LinkedHashSet<CommentRange> found = new LinkedHashSet<CommentRange>();
            Document doc = null;
            if (!StringUtil.isEmpty((String)keyword)) {
                Pattern pattern = Pattern.compile(keyword, 2);
                doc = FileDocumentManager.getInstance().getDocument(this.getFile().getVirtualFile());
                for (int i = 0; i < comments.size(); ++i) {
                    PsiComment comment = comments.get(i);
                    String text = comment.getText();
                    Matcher match = pattern.matcher(text);
                    if (!match.find()) continue;
                    found.add(UpdatePsiFileCopyright.getLineCopyrightComments(comments, doc, i, comment));
                }
            }
            PsiElement point = last;
            if (commentHere && !comments.isEmpty() && this.langOpts.isRelativeBefore()) {
                point = (PsiElement)comments.get(0);
            }
            if (commentHere && found.size() == 1) {
                CommentRange range = (CommentRange)found.iterator().next();
                if (this.langOpts.isRelativeBefore() && range.getFirst() == comments.get(0) || !this.langOpts.isRelativeBefore() && range.getLast() == comments.get(comments.size() - 1)) {
                    String newComment = this.getCommentText("", "");
                    this.resetCommentText();
                    String oldComment = UpdatePsiFileCopyright.getCommentText(doc, range);
                    if (!this.allowToReplaceRegexp(oldComment)) {
                        return;
                    }
                    if (newComment.trim().equals(oldComment)) {
                        int totalNewline;
                        String text;
                        if (!this.getLanguageOptions().isAddBlankAfter()) {
                            return;
                        }
                        PsiElement next = this.getNextSibling(range.getLast());
                        for (totalNewline = 0; next != null && totalNewline <= 1 && StringUtil.isEmptyOrSpaces((String)(text = next.getText())); totalNewline += UpdatePsiFileCopyright.countNewline(text)) {
                        }
                        if (totalNewline > 1) {
                            return;
                        }
                        point = range.getFirst();
                    } else if (!newComment.isEmpty()) {
                        int start = range.getFirst().getTextRange().getStartOffset();
                        int end = range.getLast().getTextRange().getEndOffset();
                        this.addAction(new CommentAction(2, start, end));
                        return;
                    }
                }
            }
            for (CommentRange range : found) {
                int start = range.getFirst().getTextRange().getStartOffset();
                int end = range.getLast().getTextRange().getEndOffset();
                if (range.getFirst() == comments.get(0) && range.getLast() == comments.get(comments.size() - 1)) {
                    int startLen = 0;
                    if (this.getPreviousSibling(range.getFirst()) instanceof PsiWhiteSpace) {
                        startLen = UpdatePsiFileCopyright.countNewline(this.getPreviousSibling(range.getFirst()).getText());
                    }
                    int endLen = 0;
                    if (this.getNextSibling(range.getLast()) instanceof PsiWhiteSpace) {
                        endLen = UpdatePsiFileCopyright.countNewline(this.getNextSibling(range.getLast()).getText());
                    }
                    if (startLen == 1 && this.getPreviousSibling(range.getFirst()).getTextRange().getStartOffset() > 0) {
                        start = this.getPreviousSibling(range.getFirst()).getTextRange().getStartOffset();
                    } else if (endLen > 0) {
                        end = this.getNextSibling(range.getLast()).getTextRange().getEndOffset();
                    }
                } else if (this.getNextSibling(range.getLast()) instanceof PsiWhiteSpace) {
                    end = this.getNextSibling(range.getLast()).getTextRange().getEndOffset();
                }
                if (!this.allowToReplaceRegexp(UpdatePsiFileCopyright.getCommentText(doc, range))) continue;
                this.addAction(new CommentAction(3, start, end));
            }
            if (commentHere) {
                TextRange textRange;
                String suffix = "\n";
                if (point != last && this.getPreviousSibling(point) != null && this.getPreviousSibling(point) instanceof PsiWhiteSpace && UpdatePsiFileCopyright.countNewline(suffix = this.getPreviousSibling(point).getText()) == 1) {
                    suffix = '\n' + suffix;
                }
                if (point != last && this.getPreviousSibling(point) == null) {
                    suffix = "\n\n";
                }
                if (this.getLanguageOptions().isAddBlankAfter() && UpdatePsiFileCopyright.countNewline(suffix) == 1) {
                    suffix = suffix + "\n";
                }
                String prefix = "";
                if (this.getPreviousSibling(point) != null) {
                    String ws;
                    int cnt;
                    if (this.getPreviousSibling(point) instanceof PsiComment) {
                        prefix = "\n\n";
                    }
                    if (this.getPreviousSibling(point) instanceof PsiWhiteSpace && this.getPreviousSibling(this.getPreviousSibling(point)) != null && this.getPreviousSibling(this.getPreviousSibling(point)) instanceof PsiComment && (cnt = UpdatePsiFileCopyright.countNewline(ws = this.getPreviousSibling(point).getText())) == 1) {
                        prefix = "\n";
                    }
                }
                int pos = 0;
                if (point != null && (textRange = point.getTextRange()) != null) {
                    pos = textRange.getStartOffset();
                }
                this.addAction(new CommentAction(pos, prefix, suffix));
            }
        }
        catch (PatternSyntaxException keyword) {
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static String getCommentText(Document doc, CommentRange range) {
        return doc.getCharsSequence().subSequence(range.getFirst().getTextRange().getStartOffset(), range.getLast().getTextRange().getEndOffset()).toString().trim();
    }

    private boolean allowToReplaceRegexp(String oldComment) {
        Pattern pattern;
        Matcher matcher;
        String replaceRegexp = this.myOptions.getAllowReplaceRegexp();
        return StringUtil.isEmptyOrSpaces((String)replaceRegexp) || (matcher = (pattern = Pattern.compile(replaceRegexp)).matcher(oldComment)).find();
    }

    private static CommentRange getLineCopyrightComments(List<PsiComment> comments, Document doc, int i, PsiComment comment) {
        PsiComment firstComment = comment;
        PsiComment lastComment = comment;
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(PsiUtilCore.findLanguageFromElement((PsiElement)comment));
        if (UpdatePsiFileCopyright.isLineComment(commenter, comment, doc)) {
            PsiComment cmt;
            int j;
            int sline = doc.getLineNumber(comment.getTextRange().getStartOffset());
            int eline = doc.getLineNumber(comment.getTextRange().getEndOffset());
            for (j = i - 1; j >= 0 && UpdatePsiFileCopyright.isLineComment(commenter, cmt = comments.get(j), doc) && doc.getLineNumber(cmt.getTextRange().getEndOffset()) == sline - 1; --j) {
                firstComment = cmt;
                sline = doc.getLineNumber(cmt.getTextRange().getStartOffset());
            }
            for (j = i + 1; j < comments.size() && UpdatePsiFileCopyright.isLineComment(commenter, cmt = comments.get(j), doc) && doc.getLineNumber(cmt.getTextRange().getStartOffset()) == eline + 1; ++j) {
                lastComment = cmt;
                eline = doc.getLineNumber(cmt.getTextRange().getEndOffset());
            }
        }
        return new CommentRange((PsiElement)firstComment, (PsiElement)lastComment);
    }

    private static boolean isLineComment(Commenter commenter, PsiComment comment, Document doc) {
        String lineCommentPrefix = commenter.getLineCommentPrefix();
        if (lineCommentPrefix != null) {
            return comment.getText().startsWith(lineCommentPrefix);
        }
        TextRange textRange = comment.getTextRange();
        return doc.getLineNumber(textRange.getStartOffset()) == doc.getLineNumber(textRange.getEndOffset());
    }

    protected PsiFile getFile() {
        return this.file;
    }

    protected LanguageOptions getLanguageOptions() {
        return this.langOpts;
    }

    protected void addAction(CommentAction action) {
        this.actions.add(action);
    }

    protected PsiElement getPreviousSibling(PsiElement element) {
        return element == null ? null : element.getPrevSibling();
    }

    protected PsiElement getNextSibling(PsiElement element) {
        return element == null ? null : element.getNextSibling();
    }

    protected void processActions(boolean allowReplacement) throws IncorrectOperationException {
        WriteCommandAction.writeCommandAction((Project)this.file.getProject()).withName(CopyrightBundle.message("command.name.update.copyright", new Object[0])).run(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(this.getRoot());
            if (doc != null) {
                PsiDocumentManager.getInstance((Project)this.file.getProject()).doPostponedOperationsAndUnblockDocument(doc);
                for (CommentAction action : this.actions) {
                    int start = action.getStart();
                    int end = action.getEnd();
                    switch (action.getType()) {
                        case 1: {
                            String comment = this.getCommentText(action.getPrefix(), action.getSuffix());
                            if (comment.isEmpty()) break;
                            doc.insertString(start, (CharSequence)comment);
                            break;
                        }
                        case 2: {
                            if (!allowReplacement) break;
                            doc.replaceString(start, end, (CharSequence)this.getCommentText("", ""));
                            break;
                        }
                        case 3: {
                            if (!allowReplacement) break;
                            doc.deleteString(start, end);
                        }
                    }
                }
                PsiDocumentManager.getInstance((Project)this.file.getProject()).commitDocument(doc);
            }
        });
    }

    public boolean hasUpdates() {
        return !this.actions.isEmpty();
    }

    protected static class CommentAction
    implements Comparable<CommentAction> {
        public static final int ACTION_INSERT = 1;
        public static final int ACTION_REPLACE = 2;
        public static final int ACTION_DELETE = 3;
        private final int type;
        private final int start;
        private final int end;
        private String prefix = null;
        private String suffix = null;

        public CommentAction(int pos, String prefix, String suffix) {
            this.type = 1;
            this.start = pos;
            this.end = pos;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public CommentAction(int type, int start, int end) {
            this.type = type;
            this.start = start;
            this.end = end;
        }

        public int getType() {
            return this.type;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public int compareTo(@NotNull CommentAction object) {
            int s = object.getStart();
            int diff = s - this.start;
            if (diff == 0) {
                diff = this.type == 1 ? 1 : -1;
            }
            return diff;
        }
    }

    private static class CommentRange {
        private final PsiElement first;
        private final PsiElement last;

        CommentRange(@NotNull PsiElement first, @NotNull PsiElement last) {
            this.first = first;
            this.last = last;
            LOG.assertTrue(first.getContainingFile() == last.getContainingFile());
        }

        public PsiElement getFirst() {
            return this.first;
        }

        public PsiElement getLast() {
            return this.last;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommentRange that = (CommentRange)o;
            if (this.first != null ? !this.first.equals(that.first) : that.first != null) {
                return false;
            }
            return !(this.last != null ? !this.last.equals(that.last) : that.last != null);
        }

        public int hashCode() {
            int result = this.first != null ? this.first.hashCode() : 0;
            result = 31 * result + (this.last != null ? this.last.hashCode() : 0);
            return result;
        }
    }
}

