/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.parser.ManifestParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestElementType;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class StandardHeaderParser
implements HeaderParser {
    public static final HeaderParser INSTANCE = new StandardHeaderParser();

    @Override
    public void parse(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (!builder.eof() && !ManifestParser.HEADER_END_TOKENS.contains(builder.getTokenType())) {
            IElementType lastToken = builder.getTokenType();
            builder.advanceLexer();
            if (lastToken != ManifestTokenType.NEWLINE || builder.getTokenType() == ManifestTokenType.SIGNIFICANT_SPACE) continue;
            break;
        }
        marker.done(ManifestElementType.HEADER_VALUE_PART);
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        return false;
    }

    @Override
    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        HeaderValue value2 = header.getHeaderValue();
        return value2 != null ? value2.getUnwrappedText() : null;
    }

    @Override
    public PsiReference @NotNull [] getReferences(@NotNull HeaderValuePart headerValuePart) {
        return PsiReference.EMPTY_ARRAY;
    }
}

