/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final String MAIN_CLASS = "Main-Class";
    public static final String PREMAIN_CLASS = "Premain-Class";
    public static final String AGENT_CLASS = "Agent-Class";
    public static final String LAUNCHER_AGENT_CLASS = "Launcher-Agent-Class";
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    public PsiReference @NotNull [] getReferences(@NotNull HeaderValuePart headerValuePart) {
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart);
        JavaClassReferenceProvider provider = module != null ? new JavaClassReferenceProvider(){

            @Override
            public GlobalSearchScope getScope(Project project) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }
        } : new JavaClassReferenceProvider();
        return provider.getReferencesByElement(headerValuePart);
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        HeaderValue value2 = header.getHeaderValue();
        if (!(value2 instanceof HeaderValuePart)) {
            return false;
        }
        HeaderValuePart valuePart = (HeaderValuePart)value2;
        String className2 = valuePart.getUnwrappedText();
        if (StringUtil.isEmptyOrSpaces((String)className2)) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.reference.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        Project project = header.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)header);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, scope);
        if (aClass == null) {
            String message2 = JavaErrorBundle.message("error.cannot.resolve.class", className2);
            holder.newAnnotation(HighlightSeverity.ERROR, message2).range(valuePart.getHighlightingRange()).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            return true;
        }
        return this.checkClass(valuePart, aClass, holder);
    }

    protected boolean checkClass(@NotNull HeaderValuePart valuePart, @NotNull PsiClass aClass, @NotNull AnnotationHolder holder) {
        String header = ((Header)valuePart.getParent()).getName();
        if (MAIN_CLASS.equals(header) && !PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.main.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        if (PREMAIN_CLASS.equals(header) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "premain")) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.pre-main.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        if ((AGENT_CLASS.equals(header) || LAUNCHER_AGENT_CLASS.equals(header)) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "agentmain")) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.agent.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        return false;
    }

    private static boolean hasInstrumenterMethod(PsiClass aClass, String methodName) {
        for (PsiMethod method : aClass.findMethodsByName(methodName, false)) {
            if (!PsiType.VOID.equals((Object)method.getReturnType()) || !method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }
}

